CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
    
	
IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'chq_emi' and column_name='vlr_limite_compra') THEN 
	ALTER TABLE chq_emi  ADD COLUMN vlr_limite_compra NUMERIC(14,4);
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd_nfce' and column_name='dt_envio') THEN 
ALTER TABLE pdv_vd_nfce ADD COLUMN dt_envio TIMESTAMP WITHOUT TIME ZONE;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd_nfce' and column_name='qtd_envio') THEN 
ALTER TABLE pdv_vd_nfce ADD COLUMN qtd_envio INTEGER;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_arv_merc_categoria' and column_name='dt_hr_carga') THEN 
ALTER TABLE est_arv_merc_categoria ADD COLUMN dt_hr_carga TIMESTAMP WITHOUT TIME ZONE;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_arv_merc_familia' and column_name='qtde_limite_venda') THEN 
ALTER TABLE est_arv_merc_familia ADD COLUMN qtde_limite_venda INTEGER DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_entidade_doacao' and column_name='cd_forn') THEN 
ALTER TABLE est_entidade_doacao ADD COLUMN cd_forn INTEGER;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_fisco_env' and column_name='sts_ultimo') THEN 
ALTER TABLE est_fisco_env ADD COLUMN sts_ultimo TIMESTAMP WITHOUT TIME ZONE;
END IF; 


COMMENT ON TABLE public.est_forma_pgto IS '--Formas de Pagamento/*Formas de Pagamento*/';

COMMENT ON COLUMN public.est_forma_pgto.cd_emp IS '--Cdigo da Emprea/**/';


IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_nf_sai' and column_name='chave_acesso') THEN 
ALTER TABLE est_nf_sai ADD COLUMN chave_acesso VARCHAR(500) DEFAULT 0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_orc' and column_name='nr_receita_pbm') THEN 
ALTER TABLE est_orc ADD COLUMN nr_receita_pbm NUMERIC(12,0);
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_orc' and column_name='flag_somente_desc_contrato') THEN 
ALTER TABLE est_orc ADD COLUMN flag_somente_desc_contrato NUMERIC(1,0) DEFAULT 0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_orc' and column_name='nsu_vnd') THEN 
ALTER TABLE est_orc ADD COLUMN nsu_vnd VARCHAR(100) DEFAULT ''::character varying;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_orc' and column_name='utiliza_desc_propz') THEN 
ALTER TABLE est_orc ADD COLUMN utiliza_desc_propz NUMERIC(1,0) DEFAULT 0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_orc' and column_name='vlr_desc_sub_total_crescevendas') THEN 
ALTER TABLE est_orc ADD COLUMN vlr_desc_sub_total_crescevendas NUMERIC(14,2) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_orc' and column_name='ind_etq_impressa') THEN 
ALTER TABLE est_orc ADD COLUMN ind_etq_impressa INTEGER DEFAULT 0;
END IF; 


COMMENT ON COLUMN public.est_orc.ind_etq_impressa IS 'indica se ja foi impresso etiqueta de receita deste orcamento';

------------------------------------------------------------------


IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_orc_pag_duplicata' and column_name='cd_orc_pag_duplicata') THEN 
ALTER TABLE public.est_orc_pag_duplicata  ADD COLUMN cd_orc_pag_duplicata INTEGER;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_orc_pag_duplicata' and column_name='qtde_parc') THEN 
ALTER TABLE public.est_orc_pag_duplicata  ADD COLUMN qtde_parc INTEGER  DEFAULT 1  NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod_cd_barra' and column_name='dt_hora_carga') THEN 
ALTER TABLE public.est_prod_cd_barra  ADD COLUMN dt_hora_carga TIMESTAMP WITHOUT TIME ZONE;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod_cd_barra' and column_name='gtin') THEN 
ALTER TABLE public.est_prod_cd_barra  ADD COLUMN gtin INTEGER DEFAULT 0 NOT NULL;

END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod_est_sngpc_lote' and column_name='cd_usu') THEN 
ALTER TABLE public.est_prod_est_sngpc_lote  ADD COLUMN cd_usu INTEGER;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod_ncm_cadastro_ibpt' and column_name='cd_filial') THEN 
ALTER TABLE public.est_prod_ncm_cadastro_ibpt  ADD COLUMN cd_filial INTEGER;
END IF; 



IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod_tbl_desc' and column_name='flag_envio_propz') THEN 
ALTER TABLE public.est_prod_tbl_desc  ADD COLUMN flag_envio_propz INTEGER DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod_tbl_desc' and column_name='flag_tp_desconto_propz') THEN 
ALTER TABLE public.est_prod_tbl_desc  ADD COLUMN flag_tp_desconto_propz INTEGER DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod_tbl_desc_qtde' and column_name='flag_tp_desconto_propz') THEN 
ALTER TABLE public.est_prod_tbl_desc_qtde  ADD COLUMN flag_tp_desconto_propz INTEGER DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod_tbl_desc_qtde' and column_name='flag_envio_propz') THEN 
ALTER TABLE public.est_prod_tbl_desc_qtde  ADD COLUMN flag_envio_propz INTEGER DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_rps_it' and column_name='cd_emp') THEN   
ALTER TABLE public.est_rps_it  ADD COLUMN cd_emp NUMERIC(6,0) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_rps_it' and column_name='cd_filial') THEN 
ALTER TABLE public.est_rps_it  ADD COLUMN cd_filial NUMERIC(6,0) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'fp_cargo_est_prod_tbl_desc_cargo' and column_name='dt_hr_carga') THEN 
ALTER TABLE public.fp_cargo_est_prod_tbl_desc_cargo  ADD COLUMN dt_hr_carga TIMESTAMP WITHOUT TIME ZONE;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_campanha_adicionais' and column_name='dt_hr_carga') THEN   
ALTER TABLE public.pdv_campanha_adicionais  ADD COLUMN dt_hr_carga TIMESTAMP WITHOUT TIME ZONE;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_campanha_adicionais' and column_name='flag_envio_propz') THEN 
ALTER TABLE public.pdv_campanha_adicionais  ADD COLUMN flag_envio_propz INTEGER DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_campanha_adicionais' and column_name='flag_tp_desconto_propz') THEN 
ALTER TABLE public.pdv_campanha_adicionais  ADD COLUMN flag_tp_desconto_propz INTEGER DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_campanha_adicionais' and column_name='flag_usa_produtos_promo_por_qtde') THEN 
ALTER TABLE public.pdv_campanha_adicionais  ADD COLUMN flag_usa_produtos_promo_por_qtde INTEGER DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_campanha_adicionais_est_arv_merc_familia_campanha' and column_name='dt_hr_carga') THEN 
ALTER TABLE public.pdv_campanha_adicionais_est_arv_merc_familia_campanha  ADD COLUMN dt_hr_carga TIMESTAMP WITHOUT TIME ZONE;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_campanha_adicionais_est_prod' and column_name='dt_hr_carga') THEN 
ALTER TABLE public.pdv_campanha_adicionais_est_prod  ADD COLUMN dt_hr_carga TIMESTAMP WITHOUT TIME ZONE;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_campanha_adicionais_est_prod_campanha' and column_name='dt_hr_carga') THEN 
ALTER TABLE public.pdv_campanha_adicionais_est_prod_campanha  ADD COLUMN dt_hr_carga TIMESTAMP WITHOUT TIME ZONE;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_campanha_adicionais_pontuacao' and column_name='dt_hr_carga') THEN 
ALTER TABLE public.pdv_campanha_adicionais_pontuacao  ADD COLUMN dt_hr_carga TIMESTAMP WITHOUT TIME ZONE;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_campanha_adicionais_pontuacao_est_prod' and column_name='dt_hr_carga') THEN 
ALTER TABLE public.pdv_campanha_adicionais_pontuacao_est_prod  ADD COLUMN dt_hr_carga TIMESTAMP WITHOUT TIME ZONE;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_campanha_adicionais_pontuacao_est_prod_campanha' and column_name='dt_hr_carga') THEN 
ALTER TABLE public.pdv_campanha_adicionais_pontuacao_est_prod_campanha  ADD COLUMN dt_hr_carga TIMESTAMP WITHOUT TIME ZONE;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_campanha_adicionais_pontuacao_prc_filial' and column_name='dt_hr_carga') THEN 
ALTER TABLE public.pdv_campanha_adicionais_pontuacao_prc_filial  ADD COLUMN dt_hr_carga TIMESTAMP WITHOUT TIME ZONE;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_campanha_adicionais_prc_filial' and column_name='dt_hr_carga') THEN  
ALTER TABLE public.pdv_campanha_adicionais_prc_filial  ADD COLUMN dt_hr_carga TIMESTAMP WITHOUT TIME ZONE; 
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_cupom' and column_name='vlr_to_vd') THEN   
ALTER TABLE public.pdv_cupom  ADD COLUMN vlr_to_vd NUMERIC(14,4) DEFAULT 0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_cupom' and column_name='vlr_canc_it') THEN 
ALTER TABLE public.pdv_cupom  ADD COLUMN vlr_canc_it NUMERIC(14,0) DEFAULT 0;  
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_cx' and column_name='chave_acesso_validador') THEN   
ALTER TABLE public.pdv_cx  ADD COLUMN chave_acesso_validador VARCHAR(200);
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_cx' and column_name='pos_qr_linx') THEN 
ALTER TABLE public.pdv_cx  ADD COLUMN pos_qr_linx VARCHAR(50);
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_cx' and column_name='exibe_qrlinx_tela') THEN 
ALTER TABLE public.pdv_cx  ADD COLUMN exibe_qrlinx_tela NUMERIC(1,0) DEFAULT 0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_cx_est_nf_serie' and column_name='cd_ctr') THEN 
ALTER TABLE public.pdv_cx_est_nf_serie  ADD COLUMN cd_ctr INTEGER;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_cx_nfce' and column_name='ativacao_sat') THEN 
ALTER TABLE public.pdv_cx_nfce  ADD COLUMN ativacao_sat VARCHAR(20) DEFAULT ''::character varying NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_cx_nfce' and column_name='fabricante_sat') THEN 
ALTER TABLE public.pdv_cx_nfce  ADD COLUMN fabricante_sat SMALLINT DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_cx_nfce' and column_name='sign_sat') THEN 
ALTER TABLE public.pdv_cx_nfce  ADD COLUMN sign_sat VARCHAR(400) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_cx_nfce_certificado' and column_name='dt_hr_carga') THEN 
ALTER TABLE public.pdv_cx_nfce_certificado  ADD COLUMN dt_hr_carga TIMESTAMP WITHOUT TIME ZONE;  
END IF; 


COMMENT ON COLUMN public.pdv_parm.tp_captura_senha_conv IS '0 - Pelo teclado 1 - Pelo Pin Pad';
-----------------------------------------------------------------------------------------------

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_parm' and column_name='blq_rec_conv') THEN 
ALTER TABLE public.pdv_parm  ADD COLUMN blq_rec_conv INTEGER DEFAULT 0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_parm' and column_name='cd_vend_default') THEN 
ALTER TABLE public.pdv_parm  ADD COLUMN cd_vend_default NUMERIC(8,0);
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_parm' and column_name='imp_somente_endereco_cupom') THEN 
ALTER TABLE public.pdv_parm  ADD COLUMN imp_somente_endereco_cupom NUMERIC(8,0);
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_parm' and column_name='permite_cons_preco_pdv') THEN 
ALTER TABLE public.pdv_parm  ADD COLUMN permite_cons_preco_pdv NUMERIC(8,0);
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_parm' and column_name='permite_desc_arredon') THEN 
ALTER TABLE public.pdv_parm  ADD COLUMN permite_desc_arredon NUMERIC(8,0);
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_parm' and column_name='permite_descontos') THEN 
ALTER TABLE public.pdv_parm  ADD COLUMN permite_descontos NUMERIC(8,0);
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_parm' and column_name='possui_consulta_chq_tef') THEN 
ALTER TABLE public.pdv_parm  ADD COLUMN possui_consulta_chq_tef NUMERIC(8,0);
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_parm' and column_name='tp_integracao_fidel') THEN 
ALTER TABLE public.pdv_parm  ADD COLUMN tp_integracao_fidel NUMERIC(8,0);
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd_it_rec' and column_name='nm_medico') THEN   
ALTER TABLE public.pdv_vd_it_rec  ADD COLUMN nm_medico VARCHAR(100) DEFAULT ''::character varying;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd_it_rec' and column_name='uf_medico') THEN 
ALTER TABLE public.pdv_vd_it_rec  ADD COLUMN uf_medico VARCHAR(4);
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd_it_rec' and column_name='nr_doc_medico') THEN 
ALTER TABLE public.pdv_vd_it_rec  ADD COLUMN nr_doc_medico VARCHAR;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd_vouchers' and column_name='ativado') THEN 
ALTER TABLE public.pdv_vd_vouchers  ADD COLUMN ativado BOOLEAN DEFAULT false;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'prc_filial' and column_name='ds_sigla_filial_cp') THEN 
ALTER TABLE public.prc_filial  ADD COLUMN ds_sigla_filial_cp VARCHAR(50);
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'prc_filial_config' and column_name='cd_usu') THEN 
ALTER TABLE public.prc_filial_config  ADD COLUMN cd_usu INTEGER;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'rc_adm_cartao_parc_minima' and column_name='cd_parc') THEN 
ALTER TABLE public.rc_adm_cartao_parc_minima  ADD COLUMN cd_parc NUMERIC(6,0) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'rc_adm_cartao_parc_minima' and column_name='cd_filial') THEN 
ALTER TABLE public.rc_adm_cartao_parc_minima  ADD COLUMN cd_filial NUMERIC(6,0) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'rc_cli_conv_dependente' and column_name='membro') THEN 
ALTER TABLE public.rc_cli_conv_dependente  ADD COLUMN membro INTEGER;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'rc_cli_conv_dependente' and column_name='dep_codigo') THEN 
ALTER TABLE public.rc_cli_conv_dependente  ADD COLUMN dep_codigo INTEGER;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'rc_cli_conv_dependente' and column_name='id_conv_orig') THEN 
ALTER TABLE public.rc_cli_conv_dependente  ADD COLUMN id_conv_orig INTEGER;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'rc_cli_conv_dependente' and column_name='sequencia') THEN 
ALTER TABLE public.rc_cli_conv_dependente  ADD COLUMN sequencia INTEGER;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'rc_cli_crediario' and column_name='dt_hr_carga') THEN 
ALTER TABLE public.rc_cli_crediario  ADD COLUMN dt_hr_carga TIMESTAMP WITHOUT TIME ZONE;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'rc_cli_fideli_pontos_est_prod_para_troca' and column_name='dt_hr_carga') THEN   
ALTER TABLE public.rc_cli_fideli_pontos_est_prod_para_troca  ADD COLUMN dt_hr_carga TIMESTAMP WITHOUT TIME ZONE;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'rc_mdl_venda' and column_name='num_max_parc_extra') THEN 
ALTER TABLE public.rc_mdl_venda  ADD COLUMN num_max_parc_extra INTEGER DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'rc_mdl_venda' and column_name='vlr_acima_parc_extra') THEN 
ALTER TABLE public.rc_mdl_venda  ADD COLUMN vlr_acima_parc_extra NUMERIC(12,2) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'rc_mdl_venda' and column_name='vlr_min_compra') THEN 
ALTER TABLE public.rc_mdl_venda  ADD COLUMN vlr_min_compra NUMERIC(12,2) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'rc_telefone' and column_name='dt_cad') THEN   
ALTER TABLE public.rc_telefone  ADD COLUMN dt_cad DATE;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'rc_cli_conv' and column_name='tp_modelo_limite') THEN   
ALTER TABLE public.rc_cli_conv  ADD COLUMN tp_modelo_limite INTEGER DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'rc_cli_conv' and column_name='num_max_parc_extra') THEN 
ALTER TABLE public.rc_cli_conv  ADD COLUMN num_max_parc_extra INTEGER DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod_preco' and column_name='perc_icms') THEN   
ALTER TABLE public.est_prod_preco  ADD COLUMN perc_icms NUMERIC(14,4);  
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod_cpl' and column_name='perc_fecop_st') THEN   
ALTER TABLE public.est_prod_cpl  ADD COLUMN perc_fecop_st NUMERIC(14,2) DEFAULT 0.0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod_cpl' and column_name='perc_fecop_ret') THEN 
ALTER TABLE public.est_prod_cpl  ADD COLUMN perc_fecop_ret NUMERIC(14,2) DEFAULT 0.0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod_cpl' and column_name='perc_icms_efet') THEN 
ALTER TABLE public.est_prod_cpl  ADD COLUMN perc_icms_efet NUMERIC(14,2) DEFAULT 0.0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod_cpl' and column_name='perc_icms_ret') THEN 
ALTER TABLE public.est_prod_cpl  ADD COLUMN perc_icms_ret NUMERIC(14,2) DEFAULT 0.0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod_cpl' and column_name='perc_red_base_calc_efet') THEN 
ALTER TABLE public.est_prod_cpl  ADD COLUMN perc_red_base_calc_efet NUMERIC(14,2) DEFAULT 0.0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod_cpl' and column_name='vlr_base_calc_efet') THEN 
ALTER TABLE public.est_prod_cpl  ADD COLUMN vlr_base_calc_efet NUMERIC(13,4);
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod_cpl' and column_name='vlr_icms_efet') THEN 
ALTER TABLE public.est_prod_cpl  ADD COLUMN vlr_icms_efet NUMERIC(13,4);
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod_cpl' and column_name='aliq_efet_icms') THEN 
ALTER TABLE public.est_prod_cpl  ADD COLUMN aliq_efet_icms NUMERIC(13,2) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod_cpl' and column_name='perc_efet_red_base_calc') THEN 
ALTER TABLE public.est_prod_cpl  ADD COLUMN perc_efet_red_base_calc NUMERIC(13,2) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod_cpl' and column_name='vlr_efet_base_icms') THEN 
ALTER TABLE public.est_prod_cpl  ADD COLUMN vlr_efet_base_icms NUMERIC(13,2) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod_cpl' and column_name='vlr_efet_icms') THEN 
ALTER TABLE public.est_prod_cpl  ADD COLUMN vlr_efet_icms NUMERIC(13,2) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod' and column_name='flag_requer_receita') THEN   
ALTER TABLE public.est_prod  ADD COLUMN flag_requer_receita INTEGER DEFAULT 0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod' and column_name='isencao_lancamento_lote') THEN 
ALTER TABLE public.est_prod  ADD COLUMN isencao_lancamento_lote INTEGER DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_cupom_nao_fiscal' and column_name='cd_adm_cartao') THEN   
ALTER TABLE public.pdv_cupom_nao_fiscal  ADD COLUMN cd_adm_cartao NUMERIC(6,0) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_cupom_nao_fiscal' and column_name='obs_sangria') THEN 
ALTER TABLE public.pdv_cupom_nao_fiscal  ADD COLUMN obs_sangria VARCHAR(100) DEFAULT ''::character varying NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_mapa_resumo' and column_name='vlr_fecop') THEN   
 ALTER TABLE public.pdv_mapa_resumo  ADD COLUMN vlr_fecop NUMERIC(10,4) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_mapa_resumo' and column_name='vlr_fecop_st') THEN 
ALTER TABLE public.pdv_mapa_resumo  ADD COLUMN vlr_fecop_st NUMERIC(10,4) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_mapa_resumo' and column_name='vlr_fecop_ret') THEN 
ALTER TABLE public.pdv_mapa_resumo  ADD COLUMN vlr_fecop_ret NUMERIC(10,4) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_mapa_resumo' and column_name='perc_fecop_st') THEN 
ALTER TABLE public.pdv_mapa_resumo  ADD COLUMN perc_fecop_st NUMERIC(10,4) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_mapa_resumo' and column_name='perc_fecop_ret') THEN 
ALTER TABLE pdv_mapa_resumo  ADD COLUMN perc_fecop_ret NUMERIC(10,4) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_mapa_resumo' and column_name='vlr_base_calc') THEN 
ALTER TABLE public.pdv_mapa_resumo  ADD COLUMN vlr_base_calc NUMERIC(30,4) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_mapa_resumo' and column_name='vlr_base_subst') THEN 
ALTER TABLE public.pdv_mapa_resumo  ADD COLUMN vlr_base_subst NUMERIC(10,4) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_mapa_resumo' and column_name='vlr_isento') THEN 
ALTER TABLE public.pdv_mapa_resumo  ADD COLUMN vlr_isento NUMERIC(10,4) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_mapa_resumo' and column_name='vlr_outras') THEN 
ALTER TABLE public.pdv_mapa_resumo  ADD COLUMN vlr_outras NUMERIC(10,4) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_mapa_resumo' and column_name='vlr_icms_subst') THEN 
ALTER TABLE public.pdv_mapa_resumo  ADD COLUMN vlr_icms_subst NUMERIC(10,4) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_mapa_resumo' and column_name='perc_icms') THEN 
ALTER TABLE public.pdv_mapa_resumo  ADD COLUMN perc_icms NUMERIC(10,4) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_mapa_resumo' and column_name='perc_icms_subst') THEN 
ALTER TABLE public.pdv_mapa_resumo  ADD COLUMN perc_icms_subst NUMERIC(10,4) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_mapa_resumo' and column_name='perc_red_base_calc') THEN 
ALTER TABLE public.pdv_mapa_resumo  ADD COLUMN perc_red_base_calc NUMERIC(10,4) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_mapa_resumo' and column_name='perc_red_base_calc_efet') THEN 
ALTER TABLE public.pdv_mapa_resumo  ADD COLUMN perc_red_base_calc_efet NUMERIC(10,4) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_mapa_resumo' and column_name='perc_icms_efet') THEN 
ALTER TABLE public.pdv_mapa_resumo  ADD COLUMN perc_icms_efet NUMERIC(10,4) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_mapa_resumo' and column_name='perc_icms_ret') THEN 
ALTER TABLE public.pdv_mapa_resumo  ADD COLUMN perc_icms_ret NUMERIC(10,4) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_mapa_resumo' and column_name='perc_st') THEN 
ALTER TABLE public.pdv_mapa_resumo  ADD COLUMN perc_st NUMERIC(10,4) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_mapa_resumo' and column_name='vlr_base_calc_efet') THEN 
ALTER TABLE public.pdv_mapa_resumo  ADD COLUMN vlr_base_calc_efet NUMERIC(10,4) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_mapa_resumo' and column_name='vlr_icms_efet') THEN 
ALTER TABLE public.pdv_mapa_resumo  ADD COLUMN vlr_icms_efet NUMERIC(10,4) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_mapa_resumo' and column_name='vlr_base_calc_ret') THEN 
ALTER TABLE public.pdv_mapa_resumo  ADD COLUMN vlr_base_calc_ret NUMERIC(10,4) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_mapa_resumo' and column_name='vlr_icms_ret') THEN 
ALTER TABLE public.pdv_mapa_resumo  ADD COLUMN vlr_icms_ret NUMERIC(10,4) DEFAULT 0 NOT NULL; 
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd' and column_name='tipo_prazo_pgto') THEN 
ALTER TABLE public.pdv_vd  ADD COLUMN tipo_prazo_pgto NUMERIC(1,0) DEFAULT 0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd' and column_name='nr_coo') THEN 
ALTER TABLE public.pdv_vd  ADD COLUMN nr_coo NUMERIC(6,0) DEFAULT 0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd' and column_name='idpagamentorespostafiscal') THEN 
ALTER TABLE public.pdv_vd  ADD COLUMN idpagamentorespostafiscal VARCHAR(50) DEFAULT ''::character varying;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd' and column_name='qtde_pontos_fidel') THEN 
ALTER TABLE public.pdv_vd  ADD COLUMN qtde_pontos_fidel NUMERIC(14,4) DEFAULT 0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd' and column_name='id_cli_fidel') THEN 
ALTER TABLE public.pdv_vd  ADD COLUMN id_cli_fidel VARCHAR(30) DEFAULT ''::character varying;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd' and column_name='pend_conf_fidelize') THEN 
ALTER TABLE public.pdv_vd  ADD COLUMN pend_conf_fidelize INTEGER DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd' and column_name='flag_somente_desc_contrato') THEN 
ALTER TABLE public.pdv_vd  ADD COLUMN flag_somente_desc_contrato NUMERIC(1,0) DEFAULT 0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd' and column_name='utiliza_desc_propz_orc') THEN 
ALTER TABLE public.pdv_vd  ADD COLUMN utiliza_desc_propz_orc NUMERIC(1,0) DEFAULT 0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd' and column_name='vlr_base_calc_efet') THEN 
ALTER TABLE public.pdv_vd  ADD COLUMN vlr_base_calc_efet NUMERIC(13,4);
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd' and column_name='vlr_efet_icms') THEN 
ALTER TABLE public.pdv_vd  ADD COLUMN vlr_efet_icms NUMERIC(13,4);
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_orc_pag_cartao' and column_name='cpf') THEN 
ALTER TABLE public.est_orc_pag_cartao  ADD COLUMN cpf VARCHAR(14);
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_orc_pag_cartao' and column_name='trn_pos') THEN 
ALTER TABLE public.est_orc_pag_cartao  ADD COLUMN trn_pos INTEGER DEFAULT 0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_cupom_it' and column_name='cd_campanha_prod') THEN   
ALTER TABLE public.pdv_cupom_it  ADD COLUMN cd_campanha_prod DOUBLE PRECISION DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_cupom_it' and column_name='venda_dependente') THEN 
ALTER TABLE public.pdv_cupom_it  ADD COLUMN venda_dependente INTEGER DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_cupom_nao_fiscal_tef' and column_name='ds_forma_pag_qr_linx') THEN   
ALTER TABLE public.pdv_cupom_nao_fiscal_tef  ADD COLUMN ds_forma_pag_qr_linx VARCHAR(30) DEFAULT '0'::character varying;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd_it' and column_name='qtde_pontos_fidel_adicional') THEN  
ALTER TABLE public.pdv_vd_it  ADD COLUMN qtde_pontos_fidel_adicional NUMERIC(14,4) DEFAULT 0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd_it' and column_name='ds_un_med') THEN 
ALTER TABLE public.pdv_vd_it  ADD COLUMN ds_un_med VARCHAR(20);
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd_it' and column_name='aliq_efet_icms') THEN 
ALTER TABLE public.pdv_vd_it  ADD COLUMN aliq_efet_icms NUMERIC(13,2) DEFAULT 0 NOT NULL;
END IF; 

COMMENT ON COLUMN public.pdv_vd_tef.st_transacao IS '0 - Pendente 1 - Efetuada 2 -Cancelada';

--2--------------------------------------------------------------------------------------------------


IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd_tef' and column_name='pendente_envio') THEN 
ALTER TABLE public.pdv_vd_tef  ADD COLUMN pendente_envio INTEGER DEFAULT 0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd_tef' and column_name='id_terminal_pos') THEN 
ALTER TABLE public.pdv_vd_tef  ADD COLUMN id_terminal_pos INTEGER DEFAULT 0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd_tef' and column_name='pendencia_envio_mfe') THEN 
ALTER TABLE public.pdv_vd_tef  ADD COLUMN pendencia_envio_mfe INTEGER DEFAULT 0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd_tef' and column_name='msg_retorno_vpe_mfe') THEN 
ALTER TABLE public.pdv_vd_tef  ADD COLUMN msg_retorno_vpe_mfe VARCHAR(80000) DEFAULT NULL::character varying;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd_tef' and column_name='nsu_autr_ecom') THEN 
ALTER TABLE public.pdv_vd_tef  ADD COLUMN nsu_autr_ecom VARCHAR(30) DEFAULT '0'::character varying;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd_tef' and column_name='ds_forma_pag_qr_linx') THEN 
ALTER TABLE public.pdv_vd_tef  ADD COLUMN ds_forma_pag_qr_linx VARCHAR(30) DEFAULT '0'::character varying;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'chq_emi' and column_name='vlr_limite_compra') THEN 	
ALTER TABLE public.chq_emi  ADD COLUMN vlr_limite_compra NUMERIC(14,4);	
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_arv_merc_categoria' and column_name='dt_hr_carga') THEN   
ALTER TABLE public.est_arv_merc_categoria  ADD COLUMN dt_hr_carga TIMESTAMP WITHOUT TIME ZONE;  
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_arv_merc_familia' and column_name='qtde_limite_venda') THEN 
ALTER TABLE public.est_arv_merc_familia  ADD COLUMN qtde_limite_venda INTEGER DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_entidade_doacao' and column_name='cd_forn') THEN 
ALTER TABLE public.est_entidade_doacao  ADD COLUMN cd_forn INTEGER;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_fisco_env' and column_name='sts_ultimo') THEN 
ALTER TABLE public.est_fisco_env  ADD COLUMN sts_ultimo TIMESTAMP WITHOUT TIME ZONE;  
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_nf_sai' and column_name='chave_acesso') THEN 	
ALTER TABLE public.est_nf_sai  ADD COLUMN chave_acesso VARCHAR(500) DEFAULT 0;	
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_orc' and column_name='nr_receita_pbm') THEN 
ALTER TABLE public.est_orc  ADD COLUMN nr_receita_pbm NUMERIC(12,0);
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_orc' and column_name='flag_somente_desc_contrato') THEN 
ALTER TABLE public.est_orc  ADD COLUMN flag_somente_desc_contrato NUMERIC(1,0) DEFAULT 0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_orc' and column_name='nsu_vnd') THEN 
ALTER TABLE public.est_orc  ADD COLUMN nsu_vnd VARCHAR(100) DEFAULT ''::character varying;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_orc' and column_name='utiliza_desc_propz') THEN 
ALTER TABLE public.est_orc  ADD COLUMN utiliza_desc_propz NUMERIC(1,0) DEFAULT 0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_orc' and column_name='vlr_desc_sub_total_crescevendas') THEN 
ALTER TABLE public.est_orc  ADD COLUMN vlr_desc_sub_total_crescevendas NUMERIC(14,2) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_orc' and column_name='ind_etq_impressa') THEN 
ALTER TABLE public.est_orc  ADD COLUMN ind_etq_impressa INTEGER DEFAULT 0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_orc_pag_duplicata' and column_name='cd_orc_pag_duplicata') THEN   
ALTER TABLE public.est_orc_pag_duplicata  ADD COLUMN cd_orc_pag_duplicata INTEGER;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod_ncm_cadastro_ibpt' and column_name='cd_emp') THEN 
ALTER TABLE public.est_prod_ncm_cadastro_ibpt  ADD COLUMN cd_emp INTEGER;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod_tbl_desc' and column_name='flag_envio_propz') THEN   
ALTER TABLE public.est_prod_tbl_desc  ADD COLUMN flag_envio_propz INTEGER DEFAULT 0 NOT NULL;
END IF;

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod_tbl_desc' and column_name='flag_tp_desconto_propz') THEN 
ALTER TABLE public.est_prod_tbl_desc  ADD COLUMN flag_tp_desconto_propz INTEGER DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod_tbl_desc_qtde' and column_name='flag_tp_desconto_propz') THEN 
ALTER TABLE public.est_prod_tbl_desc_qtde  ADD COLUMN flag_tp_desconto_propz INTEGER DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_prod_tbl_desc_qtde' and column_name='flag_envio_propz') THEN 
ALTER TABLE public.est_prod_tbl_desc_qtde  ADD COLUMN flag_envio_propz INTEGER DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_rps_it' and column_name='cd_emp') THEN   
ALTER TABLE public.est_rps_it  ADD COLUMN cd_emp NUMERIC(6,0) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'est_rps_it' and column_name='cd_filial') THEN 
ALTER TABLE public.est_rps_it  ADD COLUMN cd_filial NUMERIC(6,0) DEFAULT 0 NOT NULL;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'fp_cargo_est_prod_tbl_desc_cargo' and column_name='dt_hr_carga') THEN 
ALTER TABLE public.fp_cargo_est_prod_tbl_desc_cargo  ADD COLUMN dt_hr_carga TIMESTAMP WITHOUT TIME ZONE;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd_tef' and column_name='pendente_envio') THEN   
ALTER TABLE public.pdv_vd_tef  ADD COLUMN pendente_envio INTEGER DEFAULT 0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'chq_emi' and column_name='vlr_limite_compra') THEN 
ALTER TABLE public.pdv_vd_tef  ADD COLUMN id_terminal_pos INTEGER DEFAULT 0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd_tef' and column_name='pendencia_envio_mfe') THEN 
ALTER TABLE public.pdv_vd_tef  ADD COLUMN pendencia_envio_mfe INTEGER DEFAULT 0;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd_tef' and column_name='msg_retorno_vpe_mfe') THEN 
ALTER TABLE public.pdv_vd_tef  ADD COLUMN msg_retorno_vpe_mfe VARCHAR(80000) DEFAULT NULL::character varying;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd_tef' and column_name='nsu_autr_ecom') THEN 
ALTER TABLE public.pdv_vd_tef  ADD COLUMN nsu_autr_ecom VARCHAR(30) DEFAULT '0'::character varying;
END IF; 

IF  NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd_tef' and column_name='ds_forma_pag_qr_linx') THEN 
ALTER TABLE public.pdv_vd_tef  ADD COLUMN ds_forma_pag_qr_linx VARCHAR(30) DEFAULT '0'::character varying;
END IF; 

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addColumn() OWNER TO postgres; 
SELECT addColumn(); 
DROP FUNCTION addColumn();